//=============================================================================
// Bake Button, for when you need more food than you can shake a stick at!
//=============================================================================
class CommunistBakeButton extends DeusExDecoration;

var() float buttonLitTime;
var() sound buttonSound1;
var() sound buttonSound2;
var() bool bLit;
var() bool bWaitForEvent;
var bool isPressed;

var Vector	lastLoc, rpcLocation;
var bool		bIsMoving;

var() int NumToCook; //what are we buying?
var() localized string OvenLocStrings[11]; //string going to be used by the oven locator, saves a LOT of time...
                                          //now done in multiples for more customization
var() float CookingSkillMult;
//var() localized string ShopString;

var() int NumSpices[11], NumChocolate[11], NumSugar[11], NumSoy[11], NumFruit[11], NumBread[11];
var() class<DeusExPickup> CookableItems[11]; //what to cook for each xmode?

replication 
{
	reliable if ( Role == ROLE_Authority )
		rpcLocation;
        /*reliable if ( Role < ROLE_Authority )
                ItemPrice, bInModMode;*/
}

function Trigger(Actor Other, Pawn Instigator)
{
	if (bWaitForEvent)
		Timer();
}

function Timer()
{
	PlaySound(buttonSound2, SLOT_None);
	isPressed = False;
}

function Frob(Actor Frobber, Inventory frobWith)
{
local Actor A;
local MSMTLPlayer P;
local Credits C;
local int j;
local OvenLocPoint OvenLoc;
local PlacementLocPoint PlacementLoc;
local vector PlacementLocation, RegisterLocation;
local int xmode;
local int CookedSoFar; //how many have we cooked?
local class<DeusExPickup> tocook;
local DeusExPickup ToCookClass, cookedshit;
local int Spices, Chocolate, Sugar, Soy, Fruit, Bread;
local bool bBaked;
local int reasonablenum;
local string ToCookName;

  P = MSMTLPlayer(Frobber);

if ((P != None) && (P.InHand.IsA('CommunistCookingPot')))
{
 xmode = int(CommunistCookingPot(P.InHand).GetPropertyText("xmode"));
 tocook = CookableItems[xmode];
 Spices = NumSpices[xmode]; 
 Chocolate = NumChocolate[xmode];
 Sugar = NumSugar[xmode];
 Soy = NumSoy[xmode];
 Fruit = NumFruit[xmode];
 Bread = NumBread[xmode];
 tocookclass = Spawn(tocook,,,Location);
 tocookclass.bHidden = True;
 reasonablenum = Min(tocookclass.maxcopies, NumToCook); //make sure we don't cook more than we can carry...
 tocookname = ToCookClass.GetPropertyText("ItemName");
 tocookclass.destroy();
}

if ((P.Spices >= Spices * reasonablenum * CookingSkillMult) && (P.Chocolate >= Chocolate * reasonablenum * CookingSkillMult) && (P.Sugar >= Sugar * reasonablenum * CookingSkillMult) && (P.Soy >= Soy * reasonablenum * CookingSkillMult) && (P.Fruit >= Fruit * reasonablenum * CookingSkillMult) && (P.Bread >= Bread * reasonablenum * CookingSkillMult))
{
 forEach AllActors(class'OvenLocPoint', OvenLoc)
 {
  if ((OvenLoc.AreaString ~= OvenLocStrings[xmode]) && (j <= reasonablenum))
  {
   if (CookedSoFar < ReasonableNum)
   {
   cookedshit = Spawn(tocook,,,OvenLoc.Location, OvenLoc.Rotation);
   cookedshit.RespawnTime = 0;
   P.Spices -= Spices * CookingSkillMult;
   P.Chocolate -= Chocolate * CookingSkillMult;
   P.Sugar -= Sugar * CookingSkillMult;
   P.Soy -= Soy * CookingSkillMult;
   P.Fruit -= Fruit * CookingSkillMult;
   P.Bread -= Bread * CookingSkillMult;
   bBaked = True;
   cookedSoFar++;
   }
  }
 }
}    
if (bBaked)
{
 P.ClientMessage("|p3You have succesfully cooked |p4"$cookedsofar$" "$tocookname$"s with a cooking skill of "$int((1 - CookingSkillMult) * 400)$",|p3 Please enjoy your food.");
 CookingSkillMult -= 0.01; //we now can cook better, it will cost us less in the future
 if (CookingSkillMult < 0.75)
  CookingSkillMult = 0.750000; //otherwards this would just get silly.
 return;
}

else if (!bBaked)
{
 P.ClientMessage("|p2An error has occured, if you are sure you had enough supplies to cook "$tocook$" x|p4"$reasonablenum$" x"$CookingSkillMult$", |cf88please report this is a map bug!");
 return;
}

}

singular function SupportActor(Actor standingActor)
{
	// do nothing
}

function Bump(actor Other)
{
	// do nothing
}

simulated function Tick( float deltaTime )
{						  	
	if ( Level.NetMode != NM_Standalone )
	{
		if ( Role == ROLE_Authority )
		{
			// Was moving, now at rest
			if ( bIsMoving && ( Location == lastLoc ))
				rpcLocation = Location;

			bIsMoving = ( Location != lastLoc );
			lastLoc = Location;
		}
		else
		{
			// Our replicated location changed which means the button has come to rest
			if ( lastLoc != rpcLocation )
			{
				SetLocation( rpcLocation );
				lastLoc = rpcLocation;
			}
		}
	}
	Super.Tick( deltaTime );
}

defaultproperties
{
     buttonLitTime=0.500000
     buttonSound1=Sound'DeusExSounds.Generic.Beep1'
     bInvincible=True
     bCollideActors=True
     bBlockActors=True
     bProjTarget=True
     ItemName="|p4Bake Button"
     bPushable=False
     Physics=PHYS_None
     RemoteRole=ROLE_SimulatedProxy
     Mesh=LodMesh'DeusExDeco.Button1'
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     bCollideWorld=False
     bBlockActors=False
     Mass=5.000000
     Buoyancy=2.000000
     NumToCook=1
     NumSugar(0)=12
     NumBread(0)=2
     NumSugar(1)=8
     NumBread(1)=2
     NumFruit(1)=4
     NumSugar(2)=9
     NumBread(2)=2
     NumChocolate(2)=3
     NumSugar(3)=8
     NumBread(3)=2
     NumFruit(3)=4
     NumSugar(4)=7
     NumBread(4)=2
     NumFruit(4)=5
     NumSugar(5)=4
     NumBread(5)=2
     NumChocolate(5)=6
     NumSpices(5)=2
     NumSugar(6)=3
     NumSoy(6)=15
     NumSpices(6)=2
     NumSoy(7)=15
     NumSpices(7)=5
     NumSoy(8)=13
     NumSpices(8)=7
     NumSugar(9)=5
     NumBread(9)=2
     NumFruit(9)=7
     NumSpices(9)=3
     NumSoy(10)=15
     NumSpices(10)=10
     CookableItems(0)=class'MafoBar'
     CookableItems(1)=class'MafoBar2'
     CookableItems(2)=class'MafoBar3'
     CookableItems(3)=class'MafoBar4'
     CookableItems(4)=class'MafoBar5'
     CookableItems(5)=class'MafoBar6'
     CookableItems(6)=class'NumMeal'
     CookableItems(7)=class'NumMeal2'
     CookableItems(8)=class'NumMeal3'
     CookableItems(9)=class'MafoBar7'
     CookableItems(10)=class'Steak'
     CookingSkillMult=1
}
